<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CashBand extends Model 
{

    protected $table = 'cash_bands';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'cash_id', 'cash_statement_id', 'quantity', 'status');
    protected $visible = array('slug', 'cash_id', 'cash_statement_id', 'quantity', 'status');

    public function cashStatement()
    {
        return $this->belongsTo('App\Models\CashStatement', 'cash_statement_id');
    }

    public function cash()
    {
        return $this->belongsTo('App\Models\Cash', 'cash_id');
    }

}